import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_TYPE_REPARATION_DATA } from "@/shared/_mock/flottes/_intervention"
import { ITypeReparation } from "@/shared/types/flottes/intervention"

const reparationTypeConfig: TabConfig<ITypeReparation> = {
  type: "type de réparation",
  listTitle: "Liste des types de réparation",
  newItemTitle: "Nouveau type de réparation",
  initialData: INITIAL_TYPE_REPARATION_DATA,
  getItemCode: (reparationType) => reparationType.intitule,
}

export function useReparationTypeTabs() {
  return useTabsManager<ITypeReparation>(reparationTypeConfig)
}
