'use client';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import Switch from '@mui/material/Switch';

import TableActionColumn from '@/shared/components/table/table-action-column';
import SvgColor from '@/shared/components/svg-color';

import type { TableColumn } from '@/shared/types/common';
import { ContratStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import { formatDate, dateFormat } from '@/utils/format-time';
import { ITypeReparation } from '@/shared/types/flottes/intervention';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEditReparationType: (reparationType: ITypeReparation) => void;
  handleDetailsReparationType: (reparationType: ITypeReparation) => void;
  selected: boolean;
  row: ITypeReparation;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

const TOOLTIP_TITLES = {
  edit: 'Modifier type de réparation',
  duplicate: 'Copier type de réparation',
  active: 'Type de réparation actif',
  inactive: 'Type de réparation inactif',
};

export default function ReparationTypeTableRow({
  row,
  handleEditReparationType,
  handleDetailsReparationType,
  selected,
  onSelectRow,
  columns,
  }: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'derniereModification':
        return formatDate(value, dateFormat.isoDate);
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow hover style={{ cursor: 'pointer' }}>
      {columns
        .filter((column) => column.id !== 'isActive')
        .map((column: any, index: number) => (
          <TableCell
            onDoubleClick={() => handleDetailsReparationType(row)}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: 'nowrap', py: column.id === 'isActive' ? 0 : 'inherit', ...(index === 0 && {position: "relative"}), }}
          > 
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.intitule) }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof ITypeReparation])}
          </TableCell>
        ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: 'nowrap' }}>
        <TableActionColumn
          handleEdit={() => handleEditReparationType(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  );
}
