import { type TableConfig, useTableManager } from "@/hooks/use-table-manager"
import { _VehicleTypes, DEFAULT_VEHICLE_TYPE_TABLE_HEAD } from "@/shared/_mock/flottes/_vehicle"
import { IVehicleType } from "@/shared/types/flottes/vehicule"

const vehicleTypeConfig: TableConfig<IVehicleType> = {
  initialData: _VehicleTypes,
  defaultTableHead: DEFAULT_VEHICLE_TYPE_TABLE_HEAD,
}

export function useVehicleTypeTable() {
  return useTableManager<IVehicleType>(vehicleTypeConfig)
}
