import React, { useEffect, useState } from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { useTheme } from '@mui/material/styles';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import { IGeolocHistory } from '@/shared/types/geoloc';
import FontAwesome from '@/shared/components/fontawesome';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { ActionsIconButton } from '@/shared/theme/css';
import { faEye } from '@fortawesome/free-solid-svg-icons';
import { IconButton } from '@mui/material';
import { Stack } from '@mui/system';
import { dateFormat, formatDate } from '@/utils/format-time';
import { ContratStyledRow } from '@/shared/sections/contract/styles';

type Props = {
  handleEdit: (roadmap: IGeolocHistory) => void;
  handleDetails: (roadmap: IGeolocHistory) => void;
  handleCopy: (roadmap: IGeolocHistory) => void;
  handleView: (roadmap: IGeolocHistory) => void;
  onView: (id: number) => void;
  selected: boolean;
  dense: boolean;
  row: IGeolocHistory;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};
const TOOLTIP_TITLES = {
  view: 'Voir les détails',
  edit: 'Modifier trajet',
  copy: 'Dupliquer trajet',
  delete: 'Supprimer trajet',
};
export default function GeolocHistoryTableRow({
  row,
  handleEdit,
  onView,
  handleDetails,
  handleCopy,
  selected,
  dense,
  onSelectRow,
  columns,
}: Props) {
  const [openDialog, setOpenDialog] = useState(false);

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'tripDate':
        return formatDate(value, dateFormat.isoDate);
      default:
        return value;
    }
  };

  return (
    <>
      <ContratStyledRow hover style={{ cursor: 'pointer' }}>
        {columns.map((column: any, index: number) => (
          <TableCell
            key={column.id}
            align={column.align}
            onDoubleClick={() => handleDetails(row)}
            sx={{
              whiteSpace: 'nowrap',
              ...(index === 0 && { position: 'relative' }),
              py: column.id === 'status' ? 0 : dense ? 0 : 2.3,
            }}
          >
            <ConditionalComponent isValid={index === 0}>
              <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: 'absolute', top: 0, left: -4, height: '100%' }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof IGeolocHistory])}
          </TableCell>
        ))}

        <TableCell sx={{ whiteSpace: 'nowrap', px: 1, alignItems: 'center' }}>
          <Stack direction="row" spacing={0.5}>
            <CustomTooltip title={TOOLTIP_TITLES.view} arrow>
              <IconButton
                onClick={() => onView(Number(row.id))}
                size="small"
                sx={ActionsIconButton}
              >
                <FontAwesome icon={faEye} width={14} />
              </IconButton>
            </CustomTooltip>
          </Stack>
        </TableCell>
      </ContratStyledRow>
    </>
  );
}
