import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_GEOLOC_HISTORY_DATA } from '@/shared/_mock/_geolocData';
import {
  INITIAL_OLD_ROADMAPS_DATA,
  INITIAL_SUBMUITTED_ROADMAP_DATA,
} from '@/shared/_mock/_roadMap';
import { IOldRoadmap, ISubmittedRoadmap } from '@/shared/types/driver';
import { IGeolocHistory } from '@/shared/types/geoloc';

const oldRoadMapConfig: TabConfig<IGeolocHistory> = {
  type: 'geoloc-history',
  listTitle: 'Historique de géolocalisation',
  newItemTitle: 'Détails des trajets',
  initialData: INITIAL_GEOLOC_HISTORY_DATA,
  getItemCode: (roadmap) => roadmap.driverName,
};

export function useGeolocHistoryTabs() {
  return useTabsManager<IGeolocHistory>(oldRoadMapConfig);
}
