import React from 'react';
import { Popover, Box, Typography } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import {
  faCalendarDays,
  faInfoCircle,
  faClock,
  faCar,
  faBuilding,
  faTag,
  faIdCard
} from '@fortawesome/free-solid-svg-icons';
import { pxToRem } from '@/shared/theme/typography';
import { DriverDetail } from '../types';

interface DriverDetailsPopoverProps {
  anchorEl: HTMLElement | null;
  driver: any;
  onClose: () => void;
  isVehicle?: boolean;
}

export const DriverDetailsPopover = ({ anchorEl, driver, onClose, isVehicle = true }: DriverDetailsPopoverProps) => {
 
  const vehicleDetails: DriverDetail[] = [
  
    { icon: faIdCard, label: "Immatriculation", value: driver?.immatriculation || "Non spécifié" },
    { icon: faCar, label: "Type de véhicule", value: driver?.company || "Non spécifié" },
    { icon: faBuilding, label: "Fournisseur", value: driver?.vehicleId || "Non spécifié" },
    { icon: faCalendarDays, label: "Disponibilité", value: "Disponible" },
    { icon: faClock, label: "Durée de location", value: "Non définie" },
    { icon: faTag, label: "Statut", value: "Disponible" },
    { icon: faInfoCircle, label: "Observation", value: "Aucune observation" },
  ]

  return (
    <Popover
      sx={{
        pointerEvents: 'none',
        '.MuiPopover-paper': {
          borderRadius: 4,
          border: (theme) => `2px solid ${theme.palette.primary.main}`,
        },
      }}
      open={Boolean(anchorEl)}
      anchorEl={anchorEl}
      anchorOrigin={{
        vertical: 'center',
        horizontal: 'right',
      }}
      transformOrigin={{
        vertical: 'top',
        horizontal: 'left',
      }}
      onClose={onClose}
      disableRestoreFocus
    >
      {driver ? (
        <Box sx={{ p: 1, maxWidth: 400 }}>
          <Box
            sx={{ display: 'grid', gridTemplateColumns: 'auto 1fr', gap: '6px', alignItems: 'center' }}
          >
            <Box
              sx={{
                mr: 1,
                width: 28,
                height: 28,
                borderRadius: '50%',
                bgcolor: 'primary.main',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
              }}
            >
              <FontAwesome icon={faCar} color="white" width={14} />
            </Box>

            <Box sx={{ display: 'flex', flexDirection: 'column', justifyContent: 'center' }}>
              <Typography sx={{ fontSize: pxToRem(11) }} fontWeight={600} color="primary.main">
                Nom de Véhicule
              </Typography>
              <Typography sx={{ fontSize: pxToRem(11) }}>{driver?.name || "Non spécifié"}</Typography>
            </Box>

            {vehicleDetails.map((detail, index) => (
              <React.Fragment key={index}>
                <Box
                  sx={{ mr: 1, display: 'flex', justifyContent: 'center', alignItems: 'center' }}
                >
                  <FontAwesome icon={detail.icon} color="primary.main" width={14} />
                </Box>

                <Box
                  sx={{ display: 'flex', flexDirection: 'column', justifyContent: 'center' }}
                >
                  <Typography sx={{ fontSize: pxToRem(11) }} fontWeight={600} color="primary.main">
                    {detail.label}
                  </Typography>
                  <Typography sx={{ fontSize: pxToRem(11) }}>{detail.value}</Typography>
                </Box>
              </React.Fragment>
            ))}
          </Box>
        </Box>
      ): <></>}
    </Popover>
  );
};
