import { FormFieldType } from '@/shared/types/common';
import { IRental } from '@/shared/types/rental';

export const rentalFormFields: FormFieldType<IRental>[] = [
  {
    name: 'Immatriculation',
    label: 'Immatriculation',
    type: 'text',
    required: true,
    placeholder: 'Véhicule 014',

  },
  {
    name: 'vehicleType',
    label: 'Type de véhicule',
    type: 'select',
    options: [
      { value: 'Berline', label: 'Berline' },
      { value: 'SUV', label: 'SUV' },
      { value: 'Minibus', label: 'Minibus' },
      { value: 'Camionnette', label: 'Camionnette' },
    ],
    required: true,
    
  },
  {
    name: 'supplier',
    label: 'Fournisseur',
    type: 'select',
    options: [
      { value: 'MobilityPlus', label: 'MobilityPlus' },
      { value: 'AutoLoc', label: 'AutoLoc' },
      { value: 'RentExpress', label: 'RentExpress' },
    ],
    required: true,
    
  },
  {
    name: 'startDate',
    label: 'Date de début',
    type: 'date',
    required: true,
    
  },
  {
    name: 'endDate',
    label: 'Date de fin',
    type: 'date',
    required: true,
    
  },
  {
    name: 'startTime',
    label: 'Heure de début',
    type: 'time',
    required: true,
    placeholder: 'HH:MM',
    
  },
  {
    name: 'endTime',
    label: 'Heure de fin',
    type: 'time',
    required: true,
    placeholder: 'HH:MM',
    
  },
  {
    name: 'status',
    label: 'Status',
    type: 'select',
    options: [
      { value: 'en_cours', label: 'En cours' },
      { value: 'planifie', label: 'Planifié' },
      { value: 'termine', label: 'Terminé' },
      { value: 'annule', label: 'Annulé' },
    ],
    required: true,
    
  },
  {
    name: 'notes',
    label: 'Observation / Notes',
    type: 'textarea',
    required: false,
    placeholder: 'Aucune observation',
    rows: 3,
  },
]; 