import { Box, Button } from '@mui/material';
import { ScheduleToolbar } from '@/shared/components/schedule/schedule-toolbar';
import FontAwesome from '@/shared/components/fontawesome';
import { faAnglesLeft } from '@fortawesome/free-solid-svg-icons';
import { TableColumn, TableType, TimeUnit } from '@/shared/types/common';
import { Dayjs } from 'dayjs';
import { ReactNode } from 'react';

interface PlanningToolbarProps {
  date: Date;
  onDateChange: (date: Date | Dayjs, timeUnit?: TimeUnit) => void;  
  onZoomChange: (zoom: number) => void;
  onResetFilters: () => void;
  onFilters: (key: string, value: string, condition: string) => void;
  onBackClick: () => void;
  onAddClick: () => void;
  initialColumns: TableColumn[];
  rightAction?: ReactNode;

}

export const PlanningToolbar = ({
  date,
  onDateChange,
  onZoomChange,
  onResetFilters,
  onFilters,
  onBackClick,
  onAddClick,
  rightAction,
  initialColumns
}: PlanningToolbarProps) => {
  return (
    <Box sx={{ 
      display: 'flex', 
      alignItems: 'center',
      justifyContent: 'center',
      gap: 2,
      width: '100%',
    }}>
      <Box sx={{ flex: '0 1 auto' }}>
        <ScheduleToolbar
          date={date}
          onDateChange={onDateChange}
          onZoomChange={onZoomChange}
          onResetFilters={onResetFilters}
          onFilters={onFilters}
          initialColumns={initialColumns}
          type={TableType.Vehicle}
          rightAction={rightAction}
        />
      </Box>
      
      <Box sx={{ display: 'flex', gap: 1, alignItems: 'center' }}>
        <Button
          variant="outlined"
          size="small"
          onClick={onBackClick}
          sx={{
            borderColor: 'primary.main',
            color: 'primary.main',
            '&:hover': {
              borderColor: 'primary.dark',
              backgroundColor: 'transparent',
            },
            borderRadius: '8px',
            textTransform: 'none',
            height: '32px',
            minWidth: '32px',
            padding: '4px',
          }}
        >
          <FontAwesome
            icon={faAnglesLeft}
            width={16}
            color="primary.main"
          />
        </Button>

        <Button
          variant="contained"
          size="small"
          onClick={onAddClick}
          sx={{
            bgcolor: 'primary.main',
            color: 'white',
            '&:hover': {
              bgcolor: 'primary.dark',
            },
            borderRadius: '8px',
            textTransform: 'none',
            height: '32px',
            flex: '0 0 auto'
          }}
        >
          Ajouter
        </Button>
      </Box>
    </Box>
  );
}; 