import { styled } from '@mui/material/styles';
import { TableCell } from '@mui/material';

export const HeaderCell = styled(TableCell)(({ theme }) => ({
  fontWeight: 500,
  padding: theme.spacing(0.5),
  textAlign: 'center',
  borderBlock: `1px solid ${theme.palette.divider}`,
  borderLeft: `1px solid ${theme.palette.divider}`,
  height: 32,
}));

export const DroppableCell = styled(TableCell)<{ isOver: boolean; height: string }>(
  ({ theme, isOver, height }) => ({
    position: 'relative',
    padding: 0,
    borderBottom: `1px solid ${theme.palette.divider}`,
    borderLeft: `1px solid ${theme.palette.divider}`,
    backgroundColor: isOver ? theme.palette.primary.main : 'white',
    '&:last-of-type': {
      borderRight: `1px solid ${theme.palette.divider}`,
    },
    height,
    outline: 'none',
  })
); 