import { Box, Typography } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import { faCar, faUser } from '@fortawesome/free-solid-svg-icons';
import { faOrcid } from '@fortawesome/free-brands-svg-icons';

interface VehicleInfoProps {
  vehicle: {
    name: string;
    type?: string;
    registration?: string;
    driver?: string;
  };
}

export const VehicleInfo = ({ vehicle }: VehicleInfoProps) => (
  <>
    <Box sx={{ whiteSpace: 'nowrap' }} display="flex" alignItems="center">
      <FontAwesome
        icon={faCar}
        color="primary.main"
        width={12}
        sx={{ mr: 1 }}
      />
      <Typography sx={{ fontWeight: 500 }} variant="caption">
        {vehicle.name}
      </Typography>
    </Box>
    {vehicle.type && (
      <Box sx={{ whiteSpace: 'nowrap' }} display="flex" alignItems="center">
        <FontAwesome icon={faCar} color="primary.main" width={12} sx={{ mr: 1 }} />
        <Typography sx={{ fontWeight: 500 }} variant="caption" display="block">
          {vehicle.type}
        </Typography>
      </Box>
    )}
    {vehicle.registration && (
      <Box sx={{ whiteSpace: 'nowrap' }} display="flex" alignItems="center">
        <FontAwesome icon={faOrcid} color="primary.main" width={12} sx={{ mr: 1 }} />
        <Typography sx={{ fontWeight: 500 }} variant="caption">
          {vehicle.registration}
        </Typography>
      </Box>
    )}
    {vehicle.driver && (
      <Box sx={{ whiteSpace: 'nowrap' }} display="flex" alignItems="center">
        <FontAwesome icon={faUser} color="primary.main" width={12} sx={{ mr: 1 }} />
        <Typography sx={{ fontWeight: 500 }} variant="caption">
          {vehicle.driver}
        </Typography>
      </Box>
    )}
  </>
); 