import { IconButton, Tooltip } from '@mui/material';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faAnglesLeft, faAnglesRight } from '@fortawesome/free-solid-svg-icons';

interface ViewToggleProps {
  viewMode: 'calendar' | 'table';
  onToggle: () => void;
}

export default function ViewToggle({ viewMode, onToggle }: ViewToggleProps) {
  return (
    <Tooltip title={viewMode === 'calendar' ? 'Voir le tableau' : 'Voir le calendrier'}>
      <IconButton 
        onClick={onToggle}
        sx={{
          bgcolor: 'primary.main',
          color: 'white',
          width: 32,
          height: 32,
          '&:hover': {
            bgcolor: 'primary.dark'
          }
        }}
      >
        <FontAwesomeIcon 
          icon={viewMode === 'calendar' ? faAnglesRight : faAnglesLeft} 
          width={12}
        />
      </IconButton>
    </Tooltip>
  );
} 