import { PlanningEvent, EVENT_COLORS } from '@/shared/_mock/_planningEvents';
import { TableColumn } from '@/shared/types/common';

export const INTERVENTION_TYPES_OPTIONS = [
  { value: 'vidange', label: 'Vidange' },
  { value: 'revision_moteur', label: 'Révision moteur' },
  { value: 'controle_technique', label: 'Contrôle technique' },
  { value: 'reparation', label: 'Réparation' }
];

export const STATUS_OPTIONS = [
  { value: 'planifie', label: 'Planifié' },
  { value: 'en_cours', label: 'En cours' },
  { value: 'termine', label: 'Terminé' }
];

// Mock technicians for the example
export const TECHNICIANS = [
  { value: 'tech1', label: 'Jean Dupont' },
  { value: 'tech2', label: 'Marie Martin' },
  { value: 'tech3', label: 'Pierre Richard' },
  { value: 'tech4', label: 'Sophie Laurent' }
];

export const PLANNING_FILTER_COLUMNS = [
  {
    id: 'interventionType',
    label: "Type d'intervention",
    options: [
      { value: 'all', label: 'Tous' },
      ...INTERVENTION_TYPES_OPTIONS
    ]
  },
  {
    id: 'status',
    label: 'Statut',
    options: [
      { value: 'all', label: 'Tous' },
      ...STATUS_OPTIONS
    ]
  },
  {
    id: 'technician',
    label: 'Technicien',
    options: [
      { value: 'all', label: 'Tous' },
      ...TECHNICIANS
    ]
  }
];

export const STATUS_COLORS = {
  planifie: '#FFA500', // Orange
  en_cours: '#4CAF50', // Green
  termine: '#808080'   // Gray
};

export const INTERVAL_MINUTES = 15;
export const CELL_WIDTH = 30;
export const SLOT_HEIGHT = 35;
export const LEFT_COLUMN_WIDTH = 152;
export const DRAWER_WIDTH = 650;

export const PLANNING_TABLE_COLUMNS : TableColumn[] = [
  {
    id: 'id',
    label: 'Véhicule',
    align: 'left' as const,
    width: 200,
    type: 'text'
  },
  {
    id: 'type',
    label: 'Type',
    align: 'left' as const,
    width: 150,
    type: 'text'
  },
  {
    id: 'registration',
    label: 'Immatriculation',
    align: 'left' as const,
    width: 150,
    type: 'text'
  },
  {
    id: 'driver',
    label: 'Chauffeur',
    align: 'left' as const,
    width: 150,
    type: 'text'
  },
]; 