import { pxToRem } from '@/shared/theme/typography';
import { Theme } from '@mui/material/styles';

export const drawerStyles = {
  '& .MuiDrawer-paper': {
    width: 400,
    bgcolor: '#F8F9FA',
    border: 'none',
    borderLeft: '1px solid rgba(0, 0, 0, 0.12)',
    boxShadow: (theme: Theme) => theme.shadows[8],
    position: 'fixed',
    height: 'calc(100% - 104px)',
    right: 0,
    top: 120,
    borderTopLeftRadius: 16,
    borderBottomLeftRadius: 16,
    overflow: 'hidden',
  },
  '& .MuiBackdrop-root': {
    display: 'none'
  }
};

export const headerStyles = {
  px: 3,
  py: 2,
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'space-between',
  borderBottom: '1px solid',
  borderColor: 'divider',
  bgcolor: '#F8F9FA',
  borderTopLeftRadius: 16,
};

export const titleStyles = {
  color: 'primary.main',
  fontSize: pxToRem(20),
  fontWeight: 600
};

export const closeButtonStyles = {
  color: 'text.secondary',
  '&:hover': {
    bgcolor: 'action.hover'
  }
};

export const actionButtonsStyles = {
  mt: 3,
  display: 'flex',
  justifyContent: 'flex-end',
  gap: 1,
  '& .MuiButton-root': {
    minWidth: 100
  }
};