import { styled } from '@mui/material/styles';
import { TableCell } from '@mui/material';
import { alpha } from '@mui/material/styles';

export const HeaderCell = styled(TableCell)(({ theme }) => ({
  fontWeight: 500,
  padding: theme.spacing(0.5),
  textAlign: 'center',
  borderBlock: `1px solid ${theme.palette.divider}`,
  borderLeft: `1px solid ${theme.palette.divider}`,
  height: 32,
}));

export const toolbarButtonStyles = {
  backButton: {
    borderColor: 'primary.main',
    color: 'primary.main',
    '&:hover': {
      borderColor: 'primary.dark',
      backgroundColor: 'transparent',
    },
    borderRadius: '8px',
    textTransform: 'none',
    height: '32px',
    minWidth: '32px',
    padding: '4px',
  },
  addButton: {
    bgcolor: 'primary.main',
    color: 'white',
    '&:hover': {
      bgcolor: 'primary.dark',
    },
    borderRadius: '8px',
    textTransform: 'none',
    height: '32px',
    flex: '0 0 auto'
  }
};

export const containerStyles = {
  mainContainer: {
    display: 'flex',
    width: '100%',
    height: '100%',
    position: 'relative',
    transition: 'all 0.3s ease',
  },
  innerContainer: {
    flex: 1,
    overflow: 'hidden',
    display: 'flex',
    flexDirection: 'column',
  },
  toolbarContainer: {
    display: 'flex', 
    alignItems: 'center', 
    gap: 1,
    p: 1,
    borderBottom: '1px solid',
    borderColor: 'divider'
  },
  dateDisplay: {
    mt: 2,
    py: 1,
    borderTopLeftRadius: 16,
    borderTopRightRadius: 16,
    display: 'flex',
    fontWeight: 500,
    justifyContent: 'center',
    backgroundColor: 'white',
  },
  tableContainer: {
    flex: 1,
    maxHeight: 'calc(100vh - 200px)',
  }
}; 