'use client';

import React from 'react';
import TableFilter from '@/shared/components/table/table-filter';
import { TableType } from '@/shared/types/common';

interface CalendarFilterProps {
  onFilters: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  initialColumns: {
    id: string;
    label: string;
    type?: string;
  }[];
}

export default function CalendarFilter({
  onFilters,
  onResetFilters,
  initialColumns,
}: CalendarFilterProps) {
  return (
    <TableFilter
      onFilters={onFilters}
      onResetFilters={onResetFilters}
      initialColumns={initialColumns}
      type={TableType.Calendar}
      isChild={false}
    />
  );
}