'use client';

import {
  Box,
  Drawer,
  IconButton,
  Typography,
  Stack,
  TextField,
  MenuItem,
  Button,
} from '@mui/material';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faXmark } from '@fortawesome/free-solid-svg-icons';
import { CalendarEvent } from '../types/calendar-types';
import { EVENT_TYPES } from '../constants/event.constants';

interface Props {
  open: boolean;
  onClose: () => void;
  event?: CalendarEvent;
  onSave?: (event: CalendarEvent) => void;
}

export default function EventDrawer({ open, onClose, event, onSave }: Props) {
  return (
    <Drawer
      anchor="right"
      open={open}
      onClose={onClose}
      PaperProps={{
        sx: { width: 400 },
      }}
    >
      <Box sx={{ p: 2 }}>
        <Stack direction="row" alignItems="center" justifyContent="space-between" sx={{ mb: 3 }}>
          <Typography variant="h6">
            {event ? 'Modifier l\'événement' : 'Nouvel événement'}
          </Typography>
          <IconButton onClick={onClose}>
            <FontAwesomeIcon icon={faXmark} />
          </IconButton>
        </Stack>

        <Stack spacing={3}>
          <TextField
            fullWidth
            label="Titre"
            defaultValue={event?.title}
          />

          <TextField
            select
            fullWidth
            label="Type"
            defaultValue={event?.type || 'custom'}
          >
            {EVENT_TYPES.map((type) => (
              <MenuItem key={type.value} value={type.value}>
                {type.label}
              </MenuItem>
            ))}
          </TextField>

          <Button
            fullWidth
            variant="contained"
            onClick={onClose}
          >
            Enregistrer
          </Button>
        </Stack>
      </Box>
    </Drawer>
  );
} 