import { EVENT_COLORS } from '@/shared/_mock/_employeeEvents';
import { FormField } from '../types/calendar-types';
import { 
  faCalendar, 
  faClock, 
  faUser, 
  faLocationDot, 
  faInfoCircle, 
  faCircleExclamation, 
  faFileLines, 
  faFile, 
  faComments 
} from '@fortawesome/free-solid-svg-icons';

// Real application constants
export const EVENT_TYPES = [
    { value: 'contract_end', label: 'Fin de contrat' },
    { value: 'trial_end', label: "Fin de période d'essai" },
    { value: 'document_expiry', label: 'Expiration de documents' },
    { value: 'custom', label: 'Événement personnalisé' }
  ] as const;
  
  export const EMPLOYEE_TYPES = [
    { value: 'chauffeur', label: 'Chauffeur' },
    { value: 'sedentaire', label: 'Sédentaire' }
  ] as const;
  
  export const NOTIFICATION_INTERVALS = [
    { value: '1j', label: '1 jour avant' },
    { value: '3j', label: '3 jours avant' },
    { value: '1s', label: '1 semaine avant' },
    { value: '2s', label: '2 semaines avant' },
    { value: '1m', label: '1 mois avant' }
  ] as const;

// Calendar View Constants
export const CALENDAR_VIEWS = {
  MONTH: 'dayGridMonth',
  WEEK: 'timeGridWeek',
  DAY: 'timeGridDay',
} as const;

// Time Settings
export const TIME_SETTINGS = {
  MIN_TIME: '08:00:00',
  MAX_TIME: '19:00:00',
  SLOT_DURATION: '01:00:00',
  SLOT_HEIGHT: 50,
} as const;

// Form Fields
export const EVENT_FORM_FIELDS = {
  EMPLOYEE_TYPES: [
    { value: 'chauffeur', label: 'Chauffeur' },
    { value: 'sedentaire', label: 'Sédentaire' }
  ],
  
  EVENT_TYPES: [
    { value: 'contract_end', label: 'Fin de contrat' },
    { value: 'trial_end', label: "Fin de période d'essai" },
    { value: 'document_expiry', label: 'Expiration de documents' },
    { value: 'custom', label: 'Événement personnalisé' }
  ],

  NOTIFICATION_OPTIONS: [
    { value: '1j', label: '1 jour avant' },
    { value: '3j', label: '3 jours avant' },
    { value: '1s', label: '1 semaine avant' },
    { value: '2s', label: '2 semaines avant' },
    { value: '1m', label: '1 mois avant' }
  ]
} as const;

// Dialog Constants
export const DIALOG_CONSTANTS = {
  TITLES: {
    EDIT: "Modifier l'événement",
    CREATE: 'Créer un événement',
    DETAILS: "Détails de l'événement"
  },
  BUTTONS: {
    CANCEL: 'Annuler',
    CREATE: 'Créer',
    SAVE: 'Enregistrer',
    ADD_DOCUMENTS: 'Ajouter des documents'
  }
} as const;

// Status Options
export const STATUS_OPTIONS = [
  { value: 'pending', label: 'En attente', color: '#FFB020' },
  { value: 'toRenew', label: 'À renouveler', color: '#FF4842' },
  { value: 'expired', label: 'Expiré', color: '#212B36' },
  { value: 'renewed', label: 'Renouvelé', color: '#54D62C' }
] as const;

// Event Detail Fields
export const EVENT_DETAIL_FIELDS: FormField[] = [
  {
    name: 'date',
    label: 'Date',
    type: 'text',
    icon: faCalendar,
  },
  {
    name: 'time',
    label: 'Horaire',
    type: 'time',
    icon: faClock,
  },
  {
    name: 'employeeName',
    label: 'Chauffeur',
    type: 'text',
    icon: faUser,
  },
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    icon: faInfoCircle,
    hasCustomRender: true
  },
  {
    name: 'status',
    label: 'Statut',
    type: 'select',
    icon: faCircleExclamation,
    hasCustomRender: true
  },
  {
    name: 'description',
    label: 'Description',
    type: 'textarea',
    icon: faFileLines,
    hasCustomRender: true
  },
  {
    name: 'files',
    label: 'Documents',
    type: 'text',
    icon: faFile,
  },
  {
    name: 'comments',
    label: 'Commentaires',
    type: 'textarea',
    icon: faComments,
    hasCustomRender: true
  }
] as const;

// Filter Columns
export const FILTER_COLUMNS = [
  {
    id: 'type',
    label: 'Type',
    options: [
      { value: 'all', label: 'Tous' },
      { value: 'contract_end', label: 'Fin de contrat' },
      { value: 'trial_end', label: "Fin de période d'essai" },
      { value: 'document_expiry', label: 'Expiration de documents' },
      { value: 'custom', label: 'Événement personnalisé' }
    ]
  },
  {
    id: 'agency',
    label: 'Agence',
    options: [
      { value: 'all', label: 'Toutes' },
      { value: 'paris', label: 'Paris' },
      { value: 'lyon', label: 'Lyon' },
      { value: 'marseille', label: 'Marseille' }
    ]
  },
  {
    id: 'status',
    label: 'Statut',
    options: [
      { value: 'all', label: 'Tous' },
      { value: 'active', label: 'Actif' },
      { value: 'inactive', label: 'Inactif' },
      { value: 'vacation', label: 'En congé' }
    ]
  }
] as const;

// Calendar Configuration
export const CALENDAR_CONFIG = {
  ZOOM_DEFAULT: 50,
  ZOOM_MIN: 25,
  ZOOM_MAX: 200,
  ZOOM_STEP: 25
} as const;