import { Box } from '@mui/material';
import { styled } from '@mui/material/styles';

export const StyledCalendarContainer = styled(Box)<{ zoom: number }>(({ theme, zoom }) => ({
  height: 'calc(100vh - 200px)',
  overflow: 'auto',
  '& .fc': {
    zoom: `${zoom / 50 * 100}%`,
    height: '100%',
    borderRadius: '16px',
    border: '1px solid',
    borderColor: theme.palette.divider,
    overflow: 'hidden',
  },
  '& .fc-theme-standard td, & .fc-theme-standard th': {
    '&:first-of-type': {
      borderTopLeftRadius: '12px',
      borderBottomLeftRadius: '12px',
    },
    '&:last-of-type': {
      borderTopRightRadius: '12px',
      borderBottomRightRadius: '12px',
    }
  },
  '& .fc-scrollgrid': {
    borderRadius: '16px',
    overflow: 'hidden',
  },
  '& .fc .fc-daygrid-day-top': {
    display: 'flex',
    justifyContent: 'flex-start !important',
    flexDirection: 'row !important',
  },
  '& .fc .fc-daygrid-day-number': {
    float: 'left',
    padding: '4px 8px !important',
  },
  '& .fc .fc-timegrid-axis': {
    width: '100px !important',
    minWidth: '100px !important',
  },
  '& .fc .fc-timegrid-slot-label-cushion': {
    width: '100px !important',
    minWidth: '100px !important',
  },
  '& .fc-timegrid-axis-cushion.fc-scrollgrid-shrink-cushion': {
    width: '100px !important',
    minWidth: '100px !important',
    display: 'flex !important',
    justifyContent: 'center !important',
    alignItems: 'center !important',
    textAlign: 'center !important',
  },
  '& .fc .fc-timegrid-axis.fc-scrollgrid-shrink': {
    width: '100px !important',
    minWidth: '100px !important',
  },
  '& .fc-timegrid-slots tr': {
    height: '60px !important',
  },
  '& .fc-timegrid-slots td': {
    height: '60px !important',
  }
})); 