import { SxProps } from '@mui/material';
import { pxToRem } from '@/shared/theme/typography';

export const drawerStyles: SxProps = {
  '& .MuiDrawer-paper': {
    width: '400px',
    boxSizing: 'border-box',
    p: 0,
    bgcolor: 'background.paper',
    boxShadow: '-4px 0 8px rgba(0, 0, 0, 0.1)',
    zIndex: 1000,
    marginTop: '144px',
    height: 'calc(100% - 144px)',
    border: 'none',
    position: 'fixed',
    overflow: 'auto',
  },
  '& .MuiBackdrop-root': {
    display: 'none',
  },
};

export const headerStyles: SxProps = {
  position: 'relative',
  display: 'flex',
  alignItems: 'flex-start',
  mb: 3,
  pl: 0,
  pr: 3,
};

export const closeButtonStyles: SxProps = {
  width: 32,
  height: 32,
  color: 'primary.main',
  borderRadius: 0,
  pl: 1,
  mt: 1,
  '&:hover': {
    bgcolor: 'primary.lighter',
  },
};

export const titleStyles: SxProps = {
  fontSize: pxToRem(20),
  fontWeight: 600,
  color: 'primary.main',
  mt: 1,
};

export const actionButtonsStyles: SxProps = {
  display: 'flex',
  gap: 1,
  position: 'absolute',
  right: 24,
  top: 10,
  '& .MuiIconButton-root': {
    width: 32,
    height: 32,
    bgcolor: 'primary.main',
    color: 'white',
    '&:hover': { bgcolor: 'primary.dark' }
  }
};

export const selectStyles: SxProps = {
  height: '56px',
  fontSize: pxToRem(11),
  width: '100%',
  borderRadius: '16px',
  '& .MuiSelect-select': {
    padding: '8px 14px',
    display: 'flex',
    alignItems: 'center',
    gap: 1,
    height: '56px',
    lineHeight: '56px',
  },
  '& .MuiOutlinedInput-notchedOutline': {
    borderColor: 'primary.main',
    borderWidth: '1px',
    borderRadius: '16px',
  }
};

export const textareaStyles: SxProps = {
  '& .MuiInputBase-root': {
    minHeight: '120px',
    alignItems: 'flex-start',
    '& .MuiInputBase-input': {
      height: 'auto !important',
      minHeight: '100px !important',
      padding: '12px',
      overflow: 'auto',
    }
  }
}; 