import { Slider } from '@mui/material';
import { alpha, styled } from '@mui/system';
import { WhiteIconButtonStyle } from '@/shared/theme/css';

export const CustomSlider = styled(Slider)(({ theme }) => ({
  color: '#8B7FFF',
  height: 4,
  '& .MuiSlider-thumb': {
    height: 16,
    width: 16,
    backgroundColor: '#fff',
    border: '6px solid #8B7FFF',
    boxShadow: `0 0 0 3px white`,
  },
  '& .MuiSlider-track': {
    height: 1,
    borderRadius: 2,
  },
  '& .MuiSlider-rail': {
    height: 3,
    borderRadius: 2,
    backgroundColor: alpha(theme.palette.primary.main, 0.2),
  },
}));

export const ExtendedWhiteIconButtonStyle = {
  ...WhiteIconButtonStyle,
  padding: 0.75,
};

export const toolbarContainerStyle = {
  display: 'flex', 
  flexDirection: 'column', 
  alignItems: 'center',
  p: 0,
  width: '100%',
};

export const firstRowStyle = {
  mb: 2,
  px: 2,
};

export const navigationButtonStyle = {
  backgroundColor: 'primary.main',
  color: 'white',
  '&:hover': { backgroundColor: 'primary.dark' },
  width: 35,
  height: 35,
  borderRadius: '50%',
};

export const sliderContainerStyle = {
  height: 35,
  width: 300,
  display: 'flex',
  alignItems: 'center',
  mx: 2,
  bgcolor: 'white',
  borderRadius: 5,
  px: 1,
};

export const zoomTextStyle = {
  marginLeft: 2,
  color: '#6B7280',
  fontSize: '0.875rem',
};

export const secondRowStyle = {
  height: 60,
  width: '100%',
  display: 'flex',
  alignItems: 'center',
  position: 'relative',
  bgcolor: 'white',
  borderRadius: 2,
  boxShadow: '0px 1px 3px rgba(0, 0, 0, 0.1)',
  px: 4,
};

export const viewSelectStyle = {
  bgcolor: 'primary.main',
  color: 'white',
  minWidth: 140,
  height: 38,
  fontSize: '0.875rem',
  borderRadius: 2,
  '& .MuiOutlinedInput-notchedOutline': { 
    border: 'none' 
  },
  '& .MuiSvgIcon-root': { 
    color: 'white',
    width: 20,
    height: 20,
    right: 8,
  },
  '&:hover': {
    bgcolor: 'primary.dark',
  },
  '& .MuiSelect-select': {
    padding: '8px 32px 8px 16px',
    textAlign: 'center',
  },
  '& .MuiMenu-paper': {
    borderRadius: 16,
  }
};

export const dateDisplayStyle = {
  color: 'primary.main',
  fontSize: '1.5rem',
  fontWeight: 400,
  textTransform: 'capitalize',
  width: '100%',
  textAlign: 'center',
};

export const createEventButtonStyle = {
  display: 'flex',
  alignItems: 'center',
  bgcolor: 'primary.main',
  color: 'white',
  p: 0.2,
  borderRadius: 2,
  cursor: 'pointer',
  position: 'absolute',
  right: 32,
  '&:hover': {
    bgcolor: 'primary.dark',
  },
};

export const menuPaperProps = {
  sx: {
    borderRadius: 3,
    mt: 0.5,
    minWidth: 140,
  }
}; 