export interface ICalendarEvent {
  employeeType: string;
  type: string;
  employeeId: string;
  agenceId: string;
  date: Date;
  notes: string;
  notifications: string[];
  isAllDay: boolean;
  files?: File[];
}

export type CalendarEventField = {
  name: keyof ICalendarEvent;
  label: string;
  type: 'select' | 'date' | 'textarea' | 'multiple' | 'checkbox';
  options?: Array<{
    value: string;
    label: string;
  }>;
  required?: boolean;
  placeholder?: string;
  icon?: any;
};
