import { CalendarViewType } from './calendar-types';

export interface ScheduleToolbarProps {
  date: Date;
  view: CalendarViewType;
  onViewChange: (view: CalendarViewType) => void;
  onDateChange: (date: Date) => void;
  onZoomChange: (zoom: number) => void;
  onFilters: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  onCreateEvent: () => void;
  initialColumns: { id: string; label: string; type?: string }[];
  type: string;
}

export interface Column {
  id: string;
  label: string;
  type?: string;
} 