import * as Yup from 'yup';
import { EVENT_TYPES, EMPLOYEE_TYPES } from '../constants/event.constants';

const employeeTypeValues = Array.from(EMPLOYEE_TYPES).map(type => type.value);
const eventTypeValues = Array.from(EVENT_TYPES).map(type => type.value);

export const eventSchema = Yup.object().shape({
  employeeType: Yup.string()
    .oneOf(employeeTypeValues, 'Type d\'employé invalide')
    .required('Le type d\'employé est obligatoire'),
  type: Yup.string()
    .oneOf(eventTypeValues, 'Type d\'événement invalide')
    .required('Le type d\'événement est obligatoire'),
  employeeId: Yup.string()
    .when('employeeType', {
      is: 'chauffeur',
      then: (schema) => schema.required('Le chauffeur est obligatoire'),
      otherwise: (schema) => schema.nullable(),
    }),
  agenceId: Yup.string()
    .when('employeeType', {
      is: 'sedentaire',
      then: (schema) => schema.required('L\'agence est obligatoire'),
      otherwise: (schema) => schema.nullable(),
    }),
  date: Yup.date()
    .required('La date est obligatoire'),
  hour: Yup.string()
    .when('isAllDay', {
      is: false,
      then: (schema) => schema.required('L\'heure est obligatoire'),
      otherwise: (schema) => schema.nullable(),
    }),
  notes: Yup.string()
    .nullable(),
  notifications: Yup.array()
    .of(Yup.string())
    .nullable(),
  isAllDay: Yup.boolean()
    .required(),
  files: Yup.array()
    .of(Yup.mixed())
    .nullable(),
}); 