import { 
  faClock, 
  faCheckCircle, 
  faTimesCircle, 
  faListCheck
} from '@fortawesome/free-solid-svg-icons';
import PieCharts from '@/shared/components/charts/pie-charts';
import StatsCards from '@/shared/components/charts/stats-cards';
import { Box } from '@mui/material';
import { ILeave } from '@/shared/types/leave';

interface CongeOverviewProps {
  data: ILeave[];
}

export default function CongeOverview({ data }: CongeOverviewProps) {
  const totalDemandes = 30; 
  const demandesEnAttente = 10; 
  const demandesValidees = 10; 
  const demandesRefusees = 10; 

  const typeStats = [
    { label: 'Maladie', count: 6 },
    { label: 'Parental', count: 6 }, 
    { label: 'Annuel', count: 6 },
    { label: 'RTT', count: 6 }, 
    { label: 'Sans solde', count: 6 },
  ];

  const stats = [
    {
      title: 'Total Demandes',
      total: totalDemandes,
      icon: faListCheck,
      color: '#5176FE',
    },
    {
      title: 'En Attente',
      total: demandesEnAttente,
      icon: faClock,
      color: '#F9B90B',
    },
    {
      title: 'Validées',
      total: demandesValidees,
      icon: faCheckCircle,
      color: '#36B37E',
    },
    {
      title: 'Refusées',
      total: demandesRefusees,
      icon: faTimesCircle,
      color: '#FF3434',
    },
  ];

  const charts = [
    {
      title: 'Répartition par statut',
      data: [
        { id: 'En attente', value: 10, label: 'En attente (10) 33%', color: '#F9B90B' },
        { id: 'Validé', value: 10, label: 'Validé (10) 33%', color: '#36B37E' },
        { id: 'Refusé', value: 10, label: 'Refusé (10) 33%', color: '#FF3434' },
      ],
    },
    {
      title: 'Répartition par type',
      data: [
        { id: 'Maladie', value: 6, label: 'Maladie (6) 20%', color: '#FF6B6B' },
        { id: 'Parental', value: 6, label: 'Parental (6) 20%', color: '#4ECDC4' },
        { id: 'Annuel', value: 6, label: 'Annuel (6) 20%', color: '#45B7D1' },
        { id: 'RTT', value: 6, label: 'RTT (6) 20%', color: '#96CEB4' },
        { id: 'Sans solde', value: 6, label: 'Sans solde (6) 20%', color: '#FFB6C1' },
      ],
    },
  ];

  return (
    <Box sx={{ width: '100%' }}>
      <PieCharts charts={charts} />
      <StatsCards stats={stats} />
    </Box>
  );

}