import React from 'react';

import { TableColumn } from '@/shared/types/common';
import TableManager from '@/shared/components/table/table-manager';
import CongeTableRow from '../views/conge-table-row';
import { Box } from '@mui/material';
import { ILeave } from '@/shared/types/leave';


interface CongeTableProps {
  filteredData: ILeave[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: ILeave) => void;
  handleView: (item: ILeave) => void;
  handleViewHistory: (item: ILeave) => void;
}

export default function CongeTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  handleViewHistory,
}: CongeTableProps) {
  const renderRow = (row: ILeave) => (
    <CongeTableRow
      dense={table.dense}
      key={row.id}
      row={row}
      handleEdit={handleEdit}
      handleDetails={handleView}
     

      handleViewHistory={handleViewHistory}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)} 
          />
  );

  return (
  
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      fixedHeight="550px"
      
    />

  );
}