import * as Yup from "yup"
import { type ILeave } from "@/shared/types/leave"

export const congeSchema = Yup.object().shape({
  employeeName: Yup.string().required("Le nom de l'employé est requis"),
  leaveType: Yup.string().required('Le type de congé est requis'),
  reason: Yup.string(),
  startDate: Yup.date().required('La date de début est requise'),
  endDate: Yup.date()
    .required('La date de fin est requise')
    .min(Yup.ref('startDate'), 'La date de fin doit être postérieure à la date de début'),
  daysCount: Yup.number()
    .required('Le nombre de jours est requis')
    .min(0.5, 'Le nombre de jours doit être supérieur à 0'),
  notificationMode: Yup.string().required('Le mode de notification est requis'),
  status: Yup.string().required('Le statut est requis'),
}) 