import React from 'react';
import { ModeType } from '@/shared/types/common';
import { IFormulaire } from '@/shared/types/formulaire';
import { NewFormulaireTab } from './new-formulaire-form';
import { ExistingFormulaireForm } from './existing-formulaire-form';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

export default function FormulaireForm({
  formulaire,
  mode,
  onSave,
  onClose,
  onEdit,
  updateTabContent,
  tabId,
}: {
  formulaire: IFormulaire;
  mode: ModeType;
  onSave: (form: IFormulaire) => void;
  onClose: (forceClose: boolean) => void;
  onEdit: (form: IFormulaire) => void;
  updateTabContent: (tabId: string, newContent: IFormulaire) => void
  tabId: string
}) {
  return (
    <ConditionalComponent
      isValid={mode === 'add'}
      defaultComponent={
        <ExistingFormulaireForm
          formulaire={formulaire}
          mode={mode}
          onSave={onSave}
          onClose={(forceClose) => onClose(forceClose)}
          onEdit={onEdit}
          updateTabContent={updateTabContent}
          tabId={tabId}
        />
      }
    >
      <NewFormulaireTab formulaire={formulaire} onSave={onSave} onClose={(forceClose) => onClose(forceClose)} updateTabContent={updateTabContent} tabId={tabId} />
    </ConditionalComponent>
  );
}
