import { IFormulaire, FormulaireTab } from '@/shared/types/formulaire';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_FORMULAIRE_DATA } from '@/shared/types/formulaire';
import { useState, useCallback, useEffect } from 'react';

const getListTitleForTab = (): string => {
  return 'Liste des formulaires';
};

export function useFormulaireTabs() {
  const [activeMainTab, setActiveMainTab] = useState<FormulaireTab>(FormulaireTab.All);
  
  const formulaireConfig: TabConfig<IFormulaire> = {
    type: 'formulaire',
    listTitle: getListTitleForTab(),
    newItemTitle: 'Nouveau formulaire',
    initialData: INITIAL_FORMULAIRE_DATA,
    getItemCode: (formulaire) => formulaire.title,
  };

  const tabsManager = useTabsManager<IFormulaire>(formulaireConfig);
  const { updateListTabTitle } = tabsManager;

  useEffect(() => {
    const newTitle = getListTitleForTab();
    updateListTabTitle(newTitle);
  }, [activeMainTab, updateListTabTitle]);

  const handleMainTabChange = useCallback((tab: FormulaireTab) => {
    setActiveMainTab(tab);
    
    if (tabsManager.activeTab !== 'list') {
      tabsManager.handleTabChange({} as React.SyntheticEvent, 'list');
    }
  }, [tabsManager]);

  const handleTabAdd = useCallback(() => {
    const originalHandleTabAdd = tabsManager.handleTabAdd;    
    originalHandleTabAdd();
  }, [tabsManager.handleTabAdd]);

  return {
    ...tabsManager,
    activeMainTab,
    handleMainTabChange,
    handleTabAdd,
  };
} 