import { useTableManager } from '@/hooks/use-table-manager';
import { _appointments, DEFAULT_APPOINTMENT_HEAD } from '@/shared/_mock/_appointment';
import { IAppointment } from '@/shared/types/appointment';
import { TableType } from '@/shared/types/common';
;

const appointmentConfig = {
  type: TableType.Appointment,
  initialData: _appointments,
  defaultTableHead: DEFAULT_APPOINTMENT_HEAD,
} as const;

export function useAppointmentTable() {
  return useTableManager<IAppointment>(appointmentConfig);
}