import { useTabsManager } from "@/hooks/use-tabs-manager";
import { INITIAL_APPOINTMENT_DATA } from "@/shared/_mock/_appointment";
import { IAppointment } from "@/shared/types/appointment";
import { TabConfig } from "@/hooks/use-tabs-manager";

const appointmentConfig: TabConfig<IAppointment> = {
  type: 'appointment',
  listTitle: 'Liste des rendez-vous',
  newItemTitle: 'Nouveau rendez-vous',
  initialData: INITIAL_APPOINTMENT_DATA,
  getItemCode: (appointment) => `RDV-${appointment.driverId}`,
};

export function useAppointmentTabs() {
  return useTabsManager<IAppointment>(appointmentConfig);
}