import React from 'react';
import { IBesoinRecrutement, BesoinRecrutementTab } from '@/shared/types/besoin-recrutement';
import TableManager from '@/shared/components/table/table-manager';
import BesoinRecrutementTableRow from './besoin-recrutement-table-row';
import { TableColumn } from '@/shared/types/common';

interface BesoinRecrutementTableProps {
  filteredData: IBesoinRecrutement[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: IBesoinRecrutement) => void;
  handleView: (item: IBesoinRecrutement) => void;
  activeTab: BesoinRecrutementTab;
  onStatusChange: (row: IBesoinRecrutement, newStatus: string, field: keyof IBesoinRecrutement) => void;
}

export default function BesoinRecrutementTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  activeTab,
  onStatusChange
}: BesoinRecrutementTableProps) {
  const renderRow = (row: IBesoinRecrutement) => (
    <BesoinRecrutementTableRow
      dense={table.dense}
      key={row.id}
      row={row}
      handleEdit={handleEdit}
      handleView={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)}
      activeTab={activeTab}
      onStatusChange={onStatusChange}
    />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
    />
  );
} 