import { IBesoinRecrutement, BesoinRecrutementTab } from '@/shared/types/besoin-recrutement';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_BESOIN_RECRUTEMENT_DATA } from '@/shared/types/besoin-recrutement';
import { useState, useCallback, useEffect } from 'react';

// Function to get the appropriate list title based on the active tab
const getListTitleForTab = (tab: BesoinRecrutementTab): string => {
  switch (tab) {
    case BesoinRecrutementTab.EnAttente:
      return 'Liste des demandes en attente';
    case BesoinRecrutementTab.EnCours:
      return 'Liste des demandes en cours';
    case BesoinRecrutementTab.Traites:
      return 'Liste des demandes traitées';
    case BesoinRecrutementTab.Tous:
      return 'Liste de toutes les demandes';
    default:
      return 'Liste des demandes de recrutement';
  }
};

export function useBesoinRecrutementTabs() {
  const [activeMainTab, setActiveMainTab] = useState<BesoinRecrutementTab>(BesoinRecrutementTab.EnAttente);
  
  // Create a static config
  const besoinRecrutementConfig: TabConfig<IBesoinRecrutement> = {
    type: 'besoinRecrutement',
    listTitle: getListTitleForTab(BesoinRecrutementTab.EnAttente), // Initial title
    newItemTitle: 'Nouvelle demande de recrutement',
    initialData: INITIAL_BESOIN_RECRUTEMENT_DATA,
    getItemCode: (besoinRecrutement) => `${besoinRecrutement.demandeur} - ${besoinRecrutement.motif}`,
  };

  const tabsManager = useTabsManager<IBesoinRecrutement>(besoinRecrutementConfig);

  // Update the list tab title whenever activeMainTab changes
  useEffect(() => {
    const newTitle = getListTitleForTab(activeMainTab);
    tabsManager.updateListTabTitle(newTitle);
  }, [activeMainTab, tabsManager.updateListTabTitle]);

  const handleMainTabChange = useCallback((tab: BesoinRecrutementTab) => {
    setActiveMainTab(tab);
    
    // When changing main tabs, always return to the list view
    if (tabsManager.activeTab !== 'list') {
      tabsManager.handleTabChange({} as React.SyntheticEvent, 'list');
    }
  }, [tabsManager]);

  return {
    ...tabsManager,
    activeMainTab,
    handleMainTabChange,
  };
} 