import { FormFieldType } from '@/shared/types/common';
import { IBesoinRecrutement, BesoinRecrutementStatut } from '@/shared/types/besoin-recrutement';
import { _candidatures } from '@/shared/_mock/_candidature';

export const besoinRecrutementFormFields: FormFieldType<IBesoinRecrutement>[] = [
  {
    name: 'demandeur',
    label: 'Demandeur',
    type: 'text',
    placeholder: 'Nom du demandeur',
    required: true,
  },
  {
    name: 'motif',
    label: 'Motif',
    type: 'text',
    placeholder: 'Motif de la demande',
    required: true,
  },
  {
    name: 'nombrePostes',
    label: 'Nombre de postes',
    type: 'number',
    placeholder: 'Nombre de postes à pourvoir',
    required: true,
  },
  {
    name: 'departement',
    label: 'Département',
    type: 'text',
    placeholder: 'Département concerné',
    required: true,
  },
  {
    name: 'circuit',
    label: 'Circuit',
    type: 'text',
    placeholder: 'Circuit concerné',
    required: true,
  },
  {
    name: 'dateCreation',
    label: 'Date de création',
    type: 'text',
    required: false,
  },
  {
    name: 'statut',
    label: 'Statut',
    type: 'select',
    required: true,
    options: [
      { value: BesoinRecrutementStatut.EnAttente, label: 'En attente' },
      { value: BesoinRecrutementStatut.EnCours, label: 'En cours' },
      { value: BesoinRecrutementStatut.Traite, label: 'Traitée' },
    ],
  },
  {
    name: 'candidatureAssocieeId',
    label: 'Candidature associée',
    type: 'select',
    required: false,
    options: [
      { value: '', label: 'Aucune' },
      ..._candidatures.map((candidature) => ({
        value: candidature.id,
        label: `${candidature.nom} ${candidature.prenom}`,
      })),
    ],
  },
  {
    name: 'observation',
    label: 'Observations',
    type: 'textarea',
    placeholder: 'Observations supplémentaires',
    required: false,
  },
]; 