'use client';

import React, { useEffect } from 'react';
import { Box, Stack, Tabs, Tab } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { useBesoinRecrutementTabs } from '../hooks/use-besoin-recrutement-tabs';
import { useBesoinRecrutementTable } from '../hooks/use-besoin-recrutement-table';
import TabsCustom from '@/shared/components/tabs/tabs-custom';
import BesoinRecrutementTable from '../components/besoin-recrutement-table';
import BesoinRecrutementForm from '../components/besoin-recrutement-form';
import { IBesoinRecrutement, BesoinRecrutementTab } from '@/shared/types/besoin-recrutement';
import { TableType } from '@/shared/types/common';
import { StyledFilterTabs } from '@/shared/theme/css';
import { UnsavedChangesDialog } from '@/shared/components/dialog/UnsavedChangesDialog';

export default function BesoinRecrutementListView() {
  const {
    tabs,
    activeTab,
    activeMainTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    handleMainTabChange,
    setTabHasUnsavedChanges,
    showConfirmDialog,
    setShowConfirmDialog,
    handleConfirmDialogAction,
    updateTabContent,
  } = useBesoinRecrutementTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    handleStatusChange
  } = useBesoinRecrutementTable(activeMainTab);

  const activeTabData = React.useMemo(() => {
    return tabs.find((tab) => tab.id === activeTab);
  }, [tabs, activeTab]);

  const handleTabChangeWrapper = (event: React.SyntheticEvent, newValue: BesoinRecrutementTab) => {
    handleMainTabChange(newValue);
  };

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
      }}
    >
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type={TableType.BesoinRecrutement}
          handleTabAdd={handleTabAdd}
          activeTab={activeTab}
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead.slice(0, -1)}
          onFilters={handleFilterChange}
          filteredData={filteredData}
        />
      </Stack>

      <StyledFilterTabs
        value={activeMainTab}
        onChange={handleTabChangeWrapper}
        sx={{ mb: 2, mt: 1 }}
      >
        <Tab label="Tous" value={BesoinRecrutementTab.Tous} />
        <Tab label="En attente" value={BesoinRecrutementTab.EnAttente} />
        <Tab label="En cours" value={BesoinRecrutementTab.EnCours} />
        <Tab label="Traitées" value={BesoinRecrutementTab.Traites} />
      </StyledFilterTabs>

      <TabsCustom
        type={TableType.BesoinRecrutement}
        tabs={tabs}
        activeTab={activeTab}
        handleTabChange={handleTabChange}
        handleTabClose={handleTabClose}
      />

      {activeTab === 'list' ? (
        <BesoinRecrutementTable
          filteredData={filteredData}
          table={table}
          tableHead={tableHead}
          notFound={notFound}
          filters={filters}
          onFilterChange={handleFilterChange}
          handleEdit={handleEdit}
          handleView={handleView}
          activeTab={activeMainTab}
          onStatusChange={handleStatusChange}
          />
      ) : (
        <BesoinRecrutementForm
          besoinRecrutement={activeTabData?.content as IBesoinRecrutement}
          mode={activeTabData?.mode || 'view'}
          onSave={handleSave}
          onClose={(force) => handleCancel(activeTab, force)}
          onEdit={handleEdit}
          tableHead={tableHead}
          updateTabContent={updateTabContent}
          tabId={activeTab}
        />
      )}
      <UnsavedChangesDialog
        open={showConfirmDialog}
        onClose={() => setShowConfirmDialog(false)}
        onConfirm={() => handleConfirmDialogAction()}
        onCancel={() => setShowConfirmDialog(false)}
      />
    </Box>
  );
} 