import React from 'react';
import { ICandidature, CandidatureTab } from '@/shared/types/candidature';
import TableManager from '@/shared/components/table/table-manager';
import CandidatureTableRow from './candidature-table-row';
import { TableColumn } from '@/shared/types/common';

interface CandidatureTableProps {
  filteredData: ICandidature[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: ICandidature) => void;
  handleView: (item: ICandidature) => void;
  activeTab: CandidatureTab;
  onStatusChange: (row: ICandidature, newStatus: string, field: keyof ICandidature) => void;
}

export default function CandidatureTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  activeTab,
  onStatusChange
}: CandidatureTableProps) {
  const renderRow = (row: ICandidature) => (
    <CandidatureTableRow
      dense={table.dense}
      key={row.id}
      row={row}
      handleEdit={handleEdit}
      handleView={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)}
      activeTab={activeTab}
      onStatusChange={onStatusChange}
    />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
    />
  );
} 