import { IFormulaire, ICandidature } from '@/shared/types/candidature';
import { FormFieldType } from '@/shared/types/common';

export interface FormulaireTableRowProps {
  row: IFormulaire;
  selected: boolean;
  onSelectRow: VoidFunction;
  handleEdit: (item: IFormulaire) => void;
  handleDelete: (id: string) => void;
  handleView: (item: IFormulaire) => void;
  dense: boolean;
}

export interface FormulaireDialogProps {
  open: boolean;
  onClose: () => void;
  formulaire: IFormulaire;
  onSave: () => void;
  onInputChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
  isInTab?: boolean;
}

export interface ShareDialogProps {
  open: boolean;
  onClose: () => void;
  selectedFormulaire: IFormulaire | null;
  copyToClipboard: (text: string) => void;
}

export interface CandidatureFormProps {
  candidatureForm: Partial<ICandidature>;
  formFields: FormFieldType<ICandidature>[];
  handleCandidatureFormChange: (name: string, value: any) => void;
  handleSubmitCandidature: (e: React.FormEvent) => void;
  toggleCandidatureForm: () => void;
  copyToClipboard: (text: string) => void;
}

export const DEFAULT_CANDIDATURE_FORM: Partial<ICandidature> = {
  nom: '',
  prenom: '',
  codePostal: '',
  ville: '',
  departement: '',
  age: 0,
  dureePermis: '',
  telephone: '',
  email: '',
  type: 'Candidature chauffeur',
};

export const DEFAULT_FORMULAIRE: IFormulaire = {
  id: '',
  nom: '',
  lien: '',
  description: '',
}; 