import { IFormulaire } from '@/shared/types/candidature';
import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { _formulaires } from '@/shared/_mock/_candidature';
import { useMemo, useCallback } from 'react';
import { TableColumn, TableType } from '@/shared/types/common';

export function useFormulaireTable() {
  // Table head columns
  const tableHead: TableColumn[] = useMemo(() => [
    { id: 'nom', label: 'Nom', type: 'text'},
    { id: 'description', label: 'Description', type: 'text' },
    { id: 'lien', label: 'Lien', type: 'text' },
    { id: 'actions', label: 'Actions', align: 'center', type: 'text' },
  ], []);

  const formulaireConfig: TableConfig<IFormulaire> = {
    initialData: _formulaires,
    defaultTableHead: tableHead,
    type: TableType.Candidature
  };

  const tableManager = useTableManager<IFormulaire>(formulaireConfig);
  
  // Custom handleSave function to update the global _formulaires array
  const handleSave = useCallback((updatedFormulaire: IFormulaire) => {
    // Update the global _formulaires array
    const index = _formulaires.findIndex(f => f.id === updatedFormulaire.id);
    if (index !== -1) {
      _formulaires[index] = updatedFormulaire;
    } else {
      _formulaires.push(updatedFormulaire);
    }
    
    // Use the original handleSave from tableManager
    tableManager.handleSave(updatedFormulaire);
  }, [tableManager]);

  return {
    ...tableManager,
    handleSave,
  };
} 