import { IFormulaire } from '@/shared/types/candidature';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { useState, useCallback } from 'react';
import { DEFAULT_FORMULAIRE } from '../components/types';

const formulaireConfig: TabConfig<IFormulaire> = {
  type: 'formulaire',
  listTitle: 'Liste des formulaires',
  newItemTitle: 'Nouveau formulaire',
  initialData: DEFAULT_FORMULAIRE,
  getItemCode: (formulaire) => formulaire.nom,
};
export function useFormulaireTabs() {

  return useTabsManager<IFormulaire>(formulaireConfig);

} 