import * as Yup from 'yup';

export const formulaireSchema = Yup.object().shape({
  nom: Yup.string().required('Le nom est obligatoire'),
  lien: Yup.string()
    .url('Le lien doit être une URL valide')
    .required('Le lien est obligatoire'),
  description: Yup.string()
    .max(500, 'La description ne doit pas dépasser 500 caractères')
    .required('La description est obligatoire'),
}); 