import type React from "react"
import { Button, Grid, Stack } from "@mui/material"
import type { IDemande } from "@/shared/types/demande"
import type { FormFieldType, ModeType } from "@/shared/types/common"
import FormActions from "@/shared/components/form/form-actions"
import { mainColor } from "@/shared/components/table/styles"

interface DemandeDetailsFormProps {
  renderField: (field: FormFieldType<IDemande>) => React.ReactNode
  mode: ModeType
  onEdit: () => void
  onClose: () => void
  onSave: () => void
  demande: IDemande
}

// Document details form fields
const demandeFormFields: FormFieldType<IDemande>[] = [
  
  {
    name: "intitule",
    label: "Intitulé",
    type: "text",
    required: true,
  },
  {
    name: "description",
    label: "Description",
    type: "text",
    required: true,
  },
  {
    name: "dateCreation",
    label: "Date de Création",
    type: "date",
    required: true,
  },
  {
    name: "dateExpiration",
    label: "Date d'éxpiration",
    type: "date",
    required: true,
  },
]

export default function DemandeDetailsForm({
  renderField,
  mode,
  onEdit,
  onClose,
  onSave,
  demande,
}: DemandeDetailsFormProps) {
  const isReadOnly = mode === "view"

  return (
    <>
      <Grid container spacing={3}>
        {demandeFormFields.map((field) => (
          <Grid item xs={12} sm={6} key={field.name}>
            {renderField(field)}
          </Grid>
        ))}
        
      </Grid>
      
    </>
  )
}

