import {
  Dialog,
  DialogTitle,
  DialogContent,
  Typography,
  Box,
  Grid,
  Divider,
  Icon,
} from "@mui/material";
import FolderIcon from "@mui/icons-material/Folder";
import InsertDriveFileIcon from "@mui/icons-material/InsertDriveFile";
import FolderOpenIcon from "@mui/icons-material/FolderOpen";
import DateRangeIcon from "@mui/icons-material/DateRange";
import StorageIcon from "@mui/icons-material/Storage";
import { FolderDetails } from "@/shared/types/document";

type Props = {
  open: boolean;
  onClose: () => void;
  details: FolderDetails | null;
};

export default function FolderDetailsDialog({ open, onClose, details }: Props) {
  return (
    <Dialog open={open} onClose={onClose} maxWidth="xs" fullWidth>
      <DialogTitle
        sx={{
          display: "flex",
          alignItems: "center",
          gap: 1,
          fontWeight: "bold",
          color: "primary.main",
        }}
      >
        <FolderIcon fontSize="medium" />
        Détails du Dossier
      </DialogTitle>
      <DialogContent>
        {details ? (
          <Box sx={{ mt: 1 }}>
            <Grid container spacing={2}>
              <Grid item xs={12}>
                <Typography variant="subtitle2" color="text.secondary">
                  Nom du dossier
                </Typography>
                <Typography variant="body1" sx={{ fontWeight: 600 }}>
                  {details.name}
                </Typography>
              </Grid>

              <Grid item xs={12}>
                <Divider />
              </Grid>

              <Grid item xs={12} sm={6}>
                <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
                  <InsertDriveFileIcon color="action" />
                  <Box>
                    <Typography variant="caption" color="text.secondary">
                      Documents
                    </Typography>
                    <Typography variant="subtitle2">{details.documentCount}</Typography>
                  </Box>
                </Box>
              </Grid>

              <Grid item xs={12} sm={6}>
                <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
                  <FolderOpenIcon color="action" />
                  <Box>
                    <Typography variant="caption" color="text.secondary">
                      Sous-dossiers
                    </Typography>
                    <Typography variant="subtitle2">{details.subfolderCount}</Typography>
                  </Box>
                </Box>
              </Grid>

              <Grid item xs={12}>
                <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
                  <StorageIcon color="action" />
                  <Box>
                    <Typography variant="caption" color="text.secondary">
                      Taille totale
                    </Typography>
                    <Typography variant="subtitle2">
                      {(details.sizeInBytes / (1024 * 1024)).toFixed(2)} Mo
                    </Typography>
                  </Box>
                </Box>
              </Grid>

              <Grid item xs={12}>
                <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
                  <DateRangeIcon color="action" />
                  <Box>
                    <Typography variant="caption" color="text.secondary">
                      Date de création
                    </Typography>
                    <Typography variant="subtitle2">{details.createdDate}</Typography>
                  </Box>
                </Box>
              </Grid>
            </Grid>
          </Box>
        ) : (
          <Typography>Chargement des détails...</Typography>
        )}
      </DialogContent>
    </Dialog>
  );
}
