import {
  Dialog, DialogTitle, DialogContent, DialogActions,
  Button, Radio, Typography, Box
} from "@mui/material"
import { useEffect, useState } from "react"
import type { FolderDTO } from "@/shared/types/document"
import FolderTreeNode from "./FolderTreeNode"

interface Props {
  open: boolean
  onClose: () => void
  onConfirm: (newParentId: number | null) => void
  folders: FolderDTO[]
  currentFolderId: number
}

export default function MoveFolderDialog({
  open, onClose, onConfirm, folders, currentFolderId,
}: Props) {
  const [selectedId, setSelectedId] = useState<number | null>(null)

  useEffect(() => {
    setSelectedId(null)
  }, [open])

  return (
    <Dialog open={open} onClose={onClose} fullWidth maxWidth="sm">
      <DialogTitle>Choisir le nouveau dossier parent</DialogTitle>
      <DialogContent dividers>
        <Box>
          <Box sx={{ display: "flex", alignItems: "center", mb: 1 }}>
            <Radio
              checked={selectedId === null}
              onChange={() => setSelectedId(null)}
            />
            <Typography variant="body2">Dossier Racine</Typography>
          </Box>

          {folders.map(folder => (
            <FolderTreeNode
              key={folder.id}
              folder={folder}
              selectedId={selectedId}
              onSelect={setSelectedId}
              currentFolderId={currentFolderId}
            />
          ))}
        </Box>
      </DialogContent>
      <DialogActions>
        <Button onClick={onClose}>Annuler</Button>
        <Button
          variant="contained"
          onClick={() => onConfirm(selectedId)}
          disabled={selectedId === currentFolderId}
        >
          Déplacer ici
        </Button>
      </DialogActions>
    </Dialog>
  )
}
