"use client"

import { useState } from "react"
import { Dialog, DialogTitle, DialogContent, DialogActions, Button, TextField, IconButton } from "@mui/material"
import { Close as CloseIcon } from "@mui/icons-material"
import { StyledDialog, StyledDialogTitle } from "@/shared/sections/rh/styles"
import { AddButton } from "@/shared/components/table/styles"
import { StyledTextField } from "@/shared/theme/css"

interface CreateFolderDialogProps {
  open: boolean
  onClose: () => void
  onCreateFolder: (folderName: string) => void
}

export default function CreateFolderDialog({ open, onClose, onCreateFolder }: CreateFolderDialogProps) {
  const [folderName, setFolderName] = useState("")
  const [error, setError] = useState("")

  const handleSubmit = () => {
    if (!folderName.trim()) {
      setError("Veuillez entrer un nom de dossier")
      return
    }

    onCreateFolder(folderName)
    resetForm()
  }

  const resetForm = () => {
    setFolderName("")
    setError("")
  }

  const handleClose = () => {
    resetForm()
    onClose()
  }

  return (
    <StyledDialog open={open} onClose={handleClose} maxWidth="xs" fullWidth>
      <StyledDialogTitle>
        Créer un nouveau dossier       
      </StyledDialogTitle>
      <DialogContent>
        <StyledTextField
          autoFocus
          margin="dense"
          label="Nom du dossier"
          fullWidth
          value={folderName}
          onChange={(e) => setFolderName(e.target.value)}
          error={!!error}
          helperText={error}
          InputLabelProps={{
            shrink: true,
          }}
        />
      </DialogContent>
      <DialogActions>
        
        <AddButton variant="outlined" onClick={handleClose}>Annuler</AddButton>
        <Button variant="contained" onClick={handleSubmit} disabled={!folderName.trim()}>
          Créer
        </Button>
      </DialogActions>
    </StyledDialog>
  )
}

