import Box from '@mui/material/Box';
import IconButton from '@mui/material/IconButton';
import Typography from '@mui/material/Typography';
import Stack, { StackProps } from '@mui/material/Stack';
import FontAwesome from '@/shared/components/fontawesome';
import { faChevronDown, faChevronUp, faSquarePlus } from '@fortawesome/free-solid-svg-icons';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

interface Props extends StackProps {
    title: string;
    subTitle?: string;
    onOpen?: VoidFunction;
    collapse?: boolean;
    onCollapse?: VoidFunction;
    isAddIconVisible?: boolean;
}

export default function DocumentManagerPanel({
    title,
    subTitle,
    onOpen,
    collapse,
    onCollapse,
    isAddIconVisible = true,
    sx,
    ...other
}: Props) {

    return (
        <Stack direction="row" alignItems="center" sx={{ mb: 3, pt: 2, ...sx }} {...other}>
            <Stack flexGrow={1}>
                <Stack direction="row" alignItems="center" spacing={1} flexGrow={1}>
                    <Typography variant="h6" fontWeight="bold">{title}</Typography>
                    <ConditionalComponent isValid={isAddIconVisible}>
                        <IconButton size="small" color="primary" onClick={onOpen}>
                            <FontAwesome icon={faSquarePlus} />
                        </IconButton>
                    </ConditionalComponent>
                </Stack>
                <ConditionalComponent isValid={!!subTitle}>
                    <Box sx={{ typography: 'body2', color: 'text.disabled', mt: 0.5 }}>{subTitle}</Box>
                </ConditionalComponent>
            </Stack>
            <ConditionalComponent isValid={!!onCollapse}>
                <IconButton onClick={onCollapse}>
                    <FontAwesome icon={collapse ? faChevronDown : faChevronUp} width={14} />
                </IconButton>
            </ConditionalComponent>
        </Stack>
    );
}