// src/shared/sections/profile/language/utils/form-fields-language.ts
import { FormFieldType } from '@/shared/types/common';
import { ILanguageSettings } from '@/shared/types/ILanguageSettings';


import { faGlobe, faCalendar, faClock } from '@fortawesome/free-solid-svg-icons';

export const formFields: FormFieldType<ILanguageSettings>[] = [
  {
    name: 'language',
    label: 'Langue',
    type: 'select',
    required: true,
    icon: faGlobe,
    options: [
      { value: 'fr', label: 'Français' },
      { value: 'en', label: 'English' },
      { value: 'ar', label: 'العربية' },
    ]
  },
  {
    name: 'region',
    label: 'Région',
    type: 'select',
    required: true,
    icon: faGlobe,
    options: [
      { value: 'FR', label: 'France' },
      { value: 'MA', label: 'Maroc' },
      { value: 'TN', label: 'Tunisie' },
    ]
  },
  {
    name: 'dateFormat',
    label: 'Format de date',
    type: 'select',
    required: true,
    icon: faCalendar,
    options: [
      { value: 'DD/MM/YYYY', label: '31/12/2023' },
      { value: 'MM/DD/YYYY', label: '12/31/2023' },
      { value: 'YYYY-MM-DD', label: '2023-12-31' },
    ]
  },
  {
    name: 'timeFormat',
    label: 'Format de l\'heure',
    type: 'select',
    required: true,
    icon: faClock,
    options: [
      { value: '24', label: '24 heures (14:30)' },
      { value: '12', label: '12 heures (02:30 PM)' },
    ]
  },
 
];