import React, { useState } from 'react';
import {
  Dialog,
  IconButton,
  Typography,
  Box,
  Chip,
  Grid,
  Paper
} from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';
import MoreHorizIcon from '@mui/icons-material/MoreHoriz';
import AccessTimeIcon from '@mui/icons-material/AccessTime';
import FlightTakeoffIcon from '@mui/icons-material/FlightTakeoff';
import InfoOutlinedIcon from '@mui/icons-material/InfoOutlined';
import ArrowBackIosNewIcon from '@mui/icons-material/ArrowBackIosNew';
import ArrowForwardIosIcon from '@mui/icons-material/ArrowForwardIos';

interface AccountScheduleModalProps {
  open: boolean;
  onClose: () => void;
}

const AccountScheduleModal: React.FC<AccountScheduleModalProps> = ({ open, onClose }) => {

  const [year, setYear] = useState<number>(2025);
  const [openModal, setOpenModal] = useState<boolean>(false);
  return (
    <Dialog
      open={open}
      onClose={onClose}
      fullWidth
      maxWidth="md"
      PaperProps={{
        sx: {
          borderRadius: 2,
          maxHeight: '80vh'
        }
      }}
    >
      <Box sx={{ p: 3 }}>
        <Box sx={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', mb: 3 }}>
          <Typography variant="h5" component="h2" sx={{ fontWeight: 'bold' }}>
            Account schedule
          </Typography>
          <Box sx={{ display: 'flex', alignItems: 'center' }}>
            <Chip
              label="Par défaut"
              size="medium"
              sx={{
                bgcolor: 'rgba(25, 118, 210, 0.1)',
                color: 'primary.main',
                mr: 1
              }}
              icon={<InfoOutlinedIcon fontSize="small" />}
            />
            <IconButton onClick={() => setOpenModal(!openModal)} size="small">
              <MoreHorizIcon />
            </IconButton>
            <IconButton onClick={onClose}>
              <CloseIcon />
            </IconButton>
          </Box>

          <Dialog
            open={openModal}
            onClose={() => setOpenModal(false)}
            fullWidth
            maxWidth="sm"
            PaperProps={{
              sx: {
                borderRadius: 2,
                maxHeight: '80vh'
              }
            }}
          >

            <Box sx={{ p: 3 }}>
              <Typography variant="h5" component="h2" sx={{ fontWeight: 'bold', mb: 2 }}>
                parametres de {"l'emploi"} du temps
              </Typography>
              <Typography variant="body1" color="text.secondary">
                Vous pouvez modifier les paramètres de votre emploi du temps ici. Vous pouvez également choisir de masquer ou {"d'afficher"} certaines informations.
              </Typography>
            </Box>
          </Dialog>
        </Box>

        <Box sx={{ mb: 3 }}>
          <Box sx={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', mb: 2 }}>
            <Box sx={{ display: 'flex', alignItems: 'center' }}>
              <AccessTimeIcon sx={{ mr: 1, color: 'text.secondary' }} />
              <Typography variant="subtitle1">Jours et heures de travail</Typography>
            </Box>
            <Typography variant="subtitle1">Capacité hebdomadaire : 45 h</Typography>
          </Box>

          <Paper sx={{ bgcolor: '#f5f5f5', borderRadius: 1 }}>
            <Grid container>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1 }}>Lundi</Typography>
                <Typography variant="body2">09:00 - 18:00</Typography>
              </Grid>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1 }}>Mardi</Typography>
                <Typography variant="body2">09:00 - 18:00</Typography>
              </Grid>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1 }}>Mercredi</Typography>
                <Typography variant="body2">09:00 - 18:00</Typography>
              </Grid>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1 }}>Jeudi</Typography>
                <Typography variant="body2">09:00 - 18:00</Typography>
              </Grid>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1 }}>Vendredi</Typography>
                <Typography variant="body2">09:00 - 18:00</Typography>
              </Grid>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1, color: 'text.disabled' }}>Samedi</Typography>
              </Grid>
              <Grid item xs sx={{ p: 2, textAlign: 'center' }}>
                <Typography variant="body2" sx={{ fontWeight: 'medium', mb: 1, color: 'text.disabled' }}>Dimanche</Typography>
              </Grid>
            </Grid>
          </Paper>
        </Box>

        <Box sx={{ mb: 3 }}>
          <Box sx={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', mb: 2 }}>
            <Box sx={{ display: 'flex', alignItems: 'center' }}>
              <FlightTakeoffIcon sx={{ mr: 1, color: 'text.secondary' }} />
              <Typography variant="subtitle1">Congé {year}</Typography>
              <IconButton onClick={() => setYear(year - 1)} size="small">
                <ArrowBackIosNewIcon fontSize="small" />
              </IconButton>
              <IconButton onClick={() => setYear(year + 1)} size="small">
                <ArrowForwardIosIcon fontSize="small" />
              </IconButton>
            </Box>
            <Box sx={{ display: 'flex', alignItems: 'center' }}>
              <Chip
                label="0"
                size="medium"
                sx={{
                  bgcolor: '#424242',
                  color: 'white',
                  mr: 1,
                  borderRadius: '50%',
                  height: 32,
                  width: 32
                }}
              />
              <Typography variant="body1" sx={{ mr: 2 }}>Jours fériés</Typography>
              <Chip
                label="0"
                size="medium"
                sx={{
                  bgcolor: '#e91e63',
                  color: 'white',
                  mr: 1,
                  borderRadius: '50%',
                  height: 32,
                  width: 32
                }}
              />
              <Typography variant="body1">Autre</Typography>
            </Box>
          </Box>

          <Typography variant="body2" sx={{ color: 'text.secondary', mt: 2 }}>
            Pas de congés enregistrés cette année.
          </Typography>
        </Box>
      </Box>
    </Dialog>
  );
};

export default AccountScheduleModal;