import React, { FC } from 'react';
import {
  Card,
  CardContent,
  Avatar,
  Typography,
  List,
  ListItem,
  ListItemIcon,
  ListItemText,
  Divider,
  Box,
  alpha,
} from '@mui/material';
import EmailIcon from '@mui/icons-material/Email';
import PhoneIcon from '@mui/icons-material/Phone';
import SmartphoneIcon from '@mui/icons-material/Smartphone';
import LocationOnIcon from '@mui/icons-material/LocationOn';
import { IClient } from '@/shared/types/client';
import FontAwesome from '@/shared/components/fontawesome';
import { faCalendar } from '@fortawesome/free-regular-svg-icons';

interface Infoprops {
  client: IClient;
  open: () => void;
}
const UserProfileCard: FC<Infoprops> = ({ client, open }) => {
  const getInitials = (name: string) => {
    if (!name) return 'NA';
    const words = name.split(' ');
    const initials = words.map((word) => word.charAt(0)).join('');
    return initials.slice(0, 2).toUpperCase();
  };

  return (
    <Card
      sx={{
        borderRadius: 1,
        display: 'flex',
        alignItems: 'row',
        justifyContent: 'space-between',
        height: '100%',
      }}
    >
      <CardContent
        sx={{
          display: 'flex',
          flexDirection: 'row',
          justifyContent: 'space-between',
          width: '90%',
        }}
      >
        <Box sx={{ display: 'flex', alignItems: 'center', flexDirection: 'row', width: '100%' }}>
          <Avatar
            src={''}
            sx={{ bgcolor: '#d32f2f', width: '30vh', height: '30vh', mr: 2, fontSize: '1.5rem' }}
          >
            {getInitials(client.firstName)}
          </Avatar>

          <Box sx={{ height: '100%', width: '100%' }}>
            <Box sx={{ width: '100%', padding: 4, paddingLeft: 7, borderRadius: 1 }}>
              <Typography variant="h4" component="div" fontWeight={'medium'}>
                {client.firstName || 'Nom non disponible'}
              </Typography>
              <Typography
                variant="body2"
                color="GrayText"
                sx={{ cursor: 'pointer', paddingLeft: 0.4, paddingTop: 0.4 }}
              >
                Ajouter un intitulé de poste
              </Typography>
              <Card
                color="white"
                sx={{
                  maxWidth: '12vh',
                  cursor: 'pointer',
                  display: 'flex',
                  alignItems: 'center',
                  justifyContent: 'center',
                  backgroundColor: 'primary.main',
                  padding: 0.7,
                  borderRadius: 1,
                  fontWeight: 'medium',
                  color: 'white',
                  marginTop: 1,
                }}
              >
                Utilisateur
              </Card>
            </Box>
            <Box sx={{ padding: 4, paddingLeft: 7, paddingTop: 7 }}>
              <Typography
                variant="h4"
                fontWeight="Medium"
                fontSize="large"
                sx={{ cursor: 'pointer', paddingLeft: 0.4, paddingTop: 0.4 }}
              >
                Votre emploi du temps :
              </Typography>
              <Card
                onClick={open}
                sx={{
                  maxWidth: '23vh',
                  cursor: 'pointer',
                  display: 'flex',
                  alignItems: 'center',
                  justifyContent: 'center',
                  gap: 1.4,
                  backgroundColor: () => alpha('#a8a1f7', 0.5),
                  ':hover': {
                    backgroundColor: () => alpha('#a8a1f7', 0.3),
                  },
                  padding: 0.6,
                  borderRadius: 1,
                  fontWeight: 'medium',
                  color: 'primary.main',
                  marginTop: 2,
                }}
              >
                <FontAwesome icon={faCalendar} width={15} />
                planificateur de compte
              </Card>
            </Box>
          </Box>
        </Box>

        <List sx={{ display: 'flex', flexDirection: 'column' }}>
          <ListItem>
            <ListItemIcon>
              <EmailIcon />
            </ListItemIcon>
            <ListItemText primary="E-mail" secondary={client.email} />
          </ListItem>
          <ListItem>
            <ListItemIcon>
              <PhoneIcon />
            </ListItemIcon>
            <ListItemText primary="Téléphone" secondary={client.landlinePhone} />
          </ListItem>
          <ListItem>
            <ListItemIcon>
              <SmartphoneIcon />
            </ListItemIcon>
            <ListItemText primary="Téléphone mobile" secondary={client.phoneNumber} />
          </ListItem>
          <ListItem>
            <ListItemIcon>
              <LocationOnIcon />
            </ListItemIcon>
            <ListItemText primary="Lieu" secondary={client.addresses?.[0]?.city || 'N/A'} />
          </ListItem>
        </List>
      </CardContent>
    </Card>
  );
};

export default UserProfileCard;
