"use client";
import UserProfileCard from "../components/big-card-infos";
import SecondaryDetails from "../components/secondary-details";
import { Box } from "@mui/system";
import TeamsCard from "../components/teams-card";
import { useState } from "react";
import AccountScheduleModal from "../components/Account-schedule-modal";
import { Typography } from "@mui/material";
import { IClient, MainBranch, PortalAssignment,UserStatus ,AddressType} from "@/shared/types/client";
import { Civility } from "@/shared/types/common";

export const _clients: IClient[] = [
    {
      id: "1",
      createdAt: "2024-01-01T10:00:00Z",
      updatedAt: "2024-04-01T12:00:00Z",
      firstName: "Jean",
      lastName: "Dupont",
      email: "jean.dupont@example.com",
      phoneNumber: "0601020304",
      password: "securePassword123",
      isArchived: false,
      clientName: "Société Dupont SARL",
      landlinePhone: "0145678910",
      mainBranch: MainBranch.CLIENT,
      agencyName: "Agence Paris",
      portalAssignment: PortalAssignment.CLIENT,
      signatureDate: "2024-01-15",
      colorCode: "#FF5733",
      siret: "12345678900012",
      tva: "FR12345678901",
      agency_id: 101,
      apeCode: "6201",
      paymentDate: "2024-02-01",
      observation: "Client prioritaire",
      bankName: "BNP Paribas",
      iban: "FR7612345678901234567890123",
      auxiliaryAccount: "411000",
      salesAccount: "707000",
      accountingAccount: "401000",
      accountHolder: "Jean Dupont",
      accountAddress: "10 rue de Paris, 75001 Paris",
      swiftBic: "BNPAFRPPXXX",
      clientType: {
        id: "ct-001",
        createdAt: "2024-01-01T00:00:00Z",
        updatedAt: "2024-01-01T00:00:00Z",
        name: "ENTREPRISE"
      },
      addresses: [
        {
          id: "addr-001",
          createdAt: "2024-01-01T00:00:00Z",
          updatedAt: "2024-01-01T00:00:00Z",
          street: "10 rue de Paris",
          city: "Paris",
          zipCode: "75001",
          country: "France",
          latitude: 48.8566,
          longitude: 2.3522,
          addressType: AddressType.CLIENT
        }
      ],
      birthDate: "1980-05-15",
      birthPlace: "Lyon",
      civility: Civility.MR,
      photoUrl: "https://example.com/photos/jean.jpg",
      userStatus: UserStatus.ACTIF,
      roles: []
    },
  ];
  

export default function ClientProfileInfos() {
    const [open, setOpen] = useState(false);

    return (
        <>
            <Box sx={{ height: '100%', width: "100%", padding: 5, display: 'flex', flexDirection: 'column', gap: 3 }}>
                <Box sx={{ display: 'flex', alignItems: 'center' }}>
                    <Typography variant="h4" component="h1" sx={{ fontWeight: 500 }}>
                        Informations
                    </Typography>
                </Box>
                <UserProfileCard open={() => setOpen(true)} client={_clients[0]} />
                <Box sx={{ display: 'flex', width: "100%", gap: 2, flexDirection: { xs: 'column', sm: 'row' }, height: '100%' }} >
                    <SecondaryDetails client={_clients[0]} />
                    <TeamsCard />
                </Box>
            </Box>
            <AccountScheduleModal
                open={open}
                onClose={() => setOpen(false)}
            />
        </>
    );
}