'use client';

import React from 'react';
import { Box, Typography, Select, MenuItem, SelectChangeEvent, useTheme } from '@mui/material';
import NotificationsIcon from '@mui/icons-material/Notifications';
import EmailIcon from '@mui/icons-material/Email';
import KeyboardArrowDownIcon from '@mui/icons-material/KeyboardArrowDown';
import { StyledHeaderContainer } from '../../../styles';


interface NotificationChannelsProps {
  notificationChannel: string;
  emailChannel: string;
  onNotificationChannelChange: (event: SelectChangeEvent) => void;
  onEmailChannelChange: (event: SelectChangeEvent) => void;
}

const NotificationChannels = ({
  notificationChannel,
  emailChannel,
  onNotificationChannelChange,
  onEmailChannelChange
}: NotificationChannelsProps) => {
  const theme = useTheme();
  
  return (
    <StyledHeaderContainer>
      <Typography variant="h6" sx={{ fontWeight: 500 }}>
        Notifications du système
      </Typography>
      <Box sx={{ display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
        <NotificationsIcon sx={{ mr: 1, color: theme.palette.primary.main }} />
        <Select
          value={notificationChannel}
          onChange={onNotificationChannelChange}
          displayEmpty
          variant="standard"
          sx={{ minWidth: 180 }}
          endAdornment={<KeyboardArrowDownIcon />}
          IconComponent={() => null}
        >
          <MenuItem value="monday">Sur veillesurnous.com</MenuItem>
          <MenuItem value="desktop">Sur le bureau</MenuItem>
        </Select>
      </Box>
      <Box sx={{ display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
        <EmailIcon sx={{ mr: 1, color: theme.palette.primary.main }} />
        <Select
          value={emailChannel}
          onChange={onEmailChannelChange}
          displayEmpty
          variant="standard"
          sx={{ minWidth: 80 }}
          endAdornment={<KeyboardArrowDownIcon />}
          IconComponent={() => null}
        >
          <MenuItem value="none">Aucun</MenuItem>
          <MenuItem value="email">E-mail</MenuItem>
        </Select>
      </Box>
    </StyledHeaderContainer>
  );
};

export default NotificationChannels;