'use client';

import React from 'react';
import { Typography, Divider } from '@mui/material';

import MentionIcon from '@mui/icons-material/AlternateEmail';
import UpdateIcon from '@mui/icons-material/Update';
import ReplyIcon from '@mui/icons-material/Reply';
import NotificationSettingItem from './notification-setting-item';
import { StyledGridContainer } from '../../../styles';

export type NotificationSettingKey = 'mentions' | 'updates_owned' | 'updates_subscribed' | 'replies';

interface NotificationSettingsProps {
  notificationSettings: {
    mentions: { app: boolean, email: boolean },
    updates_owned: { app: boolean, email: boolean },
    updates_subscribed: { app: boolean, email: boolean },
    replies: { app: boolean, email: boolean }
  };
  onSettingChange: (key: NotificationSettingKey, channel: 'app' | 'email', value: boolean) => void;
}

const NOTIFICATION_ITEMS = [
  {
    key: 'mentions' as NotificationSettingKey,
    icon: <MentionIcon />,
    title: "Mentionné(e) dans une mise à jour ou réponse",
    description: "dans une mise à jour ou une réponse"
  },
  {
    key: 'updates_owned' as NotificationSettingKey,
    icon: <UpdateIcon />,
    title: "Mises à jour",
    description: "sur un élément que je possède"
  },
  {
    key: 'updates_subscribed' as NotificationSettingKey,
    icon: <UpdateIcon />,
    title: "Mises à jour",
    description: "sur un élément auquel je suis abonné(e)"
  },
  {
    key: 'replies' as NotificationSettingKey,
    icon: <ReplyIcon />,
    title: "Réponses",
    description: "à mes mises à jour et réponses"
  }
];

const NotificationSettingsSection = ({ 
  notificationSettings, 
  onSettingChange 
}: NotificationSettingsProps) => {
  return (
    <>
      <Divider sx={{ my: 2 }} />
      
      <Typography variant="subtitle1" sx={{ fontWeight: 500, mb: 2 }}>
        Communication
      </Typography>

      <StyledGridContainer>
        {NOTIFICATION_ITEMS.map((item) => (
          <NotificationSettingItem
            key={item.key}
            icon={item.icon}
            title={item.title}
            description={item.description}
            appChecked={notificationSettings[item.key].app}
            emailChecked={notificationSettings[item.key].email}
            onAppChange={(checked) => onSettingChange(item.key, 'app', checked)}
            onEmailChange={(checked) => onSettingChange(item.key, 'email', checked)}
          />
        ))}
      </StyledGridContainer>
    </>
  );
};

export default NotificationSettingsSection;